using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class QUEUEDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public QUEUEDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public QUEUE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int64 QUEUE_ID)
		{
			QUEUE objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_QUEUE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, QUEUE_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<QUEUE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<QUEUE> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_QUEUE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public Int64 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, QUEUE objSave)
		{
			Int64? objReturn = objSave.QUEUE_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_QUEUE_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, objSave.ITEM_DESCRIPTION, objSave.ITEM_ID, objSave.QUEUE_BATCH_ID, ref objReturn, objSave.REGISTRANT_ID, objSave.STD_QUEUE_TYPE_ID, DateTime.Now, objSave.UPDATEDBY, objSave.USER_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int64 QUEUE_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_QUEUE_delete(CURRENT_USER, CURRENT_REGISTRY_ID, QUEUE_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
